; DrafTools   [Version 1.00] 9/25/93       
;

(defun SETSCALES (scale)
  (setvar "DIMSCALE" (* (getvar "DIMSCALE") scale))
  (setvar "LTSCALE" (* (getvar "LTSCALE") scale))
  (setvar "TEXTSIZE" (* (getvar "DIMTXT") scale))
)

(defun getdwgname ( / v1 v2)
  (if
    (zerop (getvar "DWGTITLED"))
    ""
    (progn
      (setq v1 (strlen (setq v2 (getvar "DWGNAME"))))
      (while (and (> v1 0) (/= "\\" (substr v2 v1 1)))
        (setq v1 (1- v1))
      )
      (substr v2 (1+ v1))
    )
  )
)

(defun getattribval (ent tag / ca t1)
  (while (and ent (setq ent (entnext ent)))
    (setq t1 (entget ent))
    (if 
      (and (= "ATTRIB" (cdr (assoc '0 t1))) (= tag (cdr (assoc '2 t1))))
      (setq ent nil)
      (setq t1 nil)
    )
  )  
  (if t1 (cdr (assoc '1 t1)) t1)
)

(defun pack (s / t1)
  (if (= (type s) 'STR)
    (progn
      (setq t1 (strlen s))
      (while (and (> t1 0) (= " " (substr s t1 1)) (setq t1 (1- t1))))
      (if (= 0 t1) "" (substr s 1 t1))
    )
    ""
  )
)

(defun lookup (fname tag index field / fh totrec rec reclen fields t1 s)
  (setq fields nil)
  (if
    (and
      (or 
        (setq fh (open (strcat (if *LISPPATH *LISPPATH "") fname) "r"))
        (setq fh (open fname "r"))
      )
      (setq tag (pack (getattribval (if *TBATTRIB *TBATTRIB (entlast)) tag)))
      (/= "" (pack tag))
    )
    (if
      (and
        (princ (strcat "\nSearching Database " fname " for " tag "..."))
        (repeat 4 (read-char fh))
        (setq totrec (read-char fh))
        (setq t1 (read-char fh))
        (setq totrec (+ totrec (* 256 t1)))
        (setq t1 (read-char fh))
        (setq totrec (+ totrec (* 65536 t1)))
        (setq t1 (read-char fh))
        (setq totrec (+ totrec (* 16777216 t1)))
        (repeat 2 (read-char fh))
        (setq reclen (read-char fh))
        (setq t1 (read-char fh))
        (setq reclen (+ reclen (* 256 t1)))
        (repeat 20 (read-char fh))
        (setq t1 (read-char fh))
        (while (and t1 (/= t1 10))
          (setq fields
            (cons
              (list
                (pack
                  (substr
                    (progn
                      (setq rec (chr (if (zerop t1) 32 t1)))
                      (repeat 31 
                        (setq rec 
                          (strcat 
                            rec 
                            (if 
                              (setq t1 (read-char fh)) 
                              (chr (if (zerop t1) 32 t1)) 
                              " "
                            )
                          )
                        )
                      )
                    )
                    1
                    11
                  )
                )
                (if (= "" (setq t1 (substr rec 12 1))) nil t1)
                (setq t1 (ascii (substr rec 17 1)))
                (if fields (+ (last (car fields)) (nth 2 (car fields))) 1)
              )
              fields
            )
          )
          (setq t1 (read-char fh))
        )
        (= "C" (cadr (assoc field fields)))
        (= "C" (cadr (assoc index fields)))
        (setq rec 1)
        (while (and rec (<= rec totrec) (read-char fh))
          (setq s "")
          (repeat (1- reclen)
            (setq s 
              (strcat 
                s 
                (if 
                  (setq t1 (read-char fh)) 
                  (chr (if (zerop t1) 32 t1))
                  " "
                )
              )
            )
          )
          (if
            (= tag 
              (pack 
                (substr 
                  s 
                  (nth 3 (assoc index fields)) 
                  (nth 2 (assoc index fields))
                )
              )
            )
            (not (setq rec nil))
            (setq rec (1+ rec))
          )
        )
        (setq rec 
          (if rec 
            "?N" 
            (pack 
              (substr 
                s 
                (nth 3 (assoc field fields)) 
                (nth 2 (assoc field fields))
              )
            )
          )
        )
      )
      (progn (close fh) rec)
      "?E"
    )
    (if fh (progn (close fh) (if (= "" (pack tag)) "" "?A")) "?F")
  )
)
