
#define MAX_AREAS   200
#define MAX_AFIX     10
#define MAX_SEND     10
#define MAX_FREQ     10
#define MAX_TWIT     10
#define MAX_MACRO    10

struct _MAREA {
   char tag[41],
        desc[41];
   int  SPARE1,
        SPARE2;
   int  new:1,
        arc:1,
        preserve:1,
        personal:1,
        UNUSED:12;
   long lastrec;
   char origin[41];
};

struct _AFIX {
   int add;
   char area[21];
};

struct _SEND {
   char file[31],
        desc[65];
};

struct _FREQ {
   char file[31];
};

struct _TWIT {
   char twit[36];
   int  to:1,
        from:1,
        SPARE:14;
};

struct _MACRO {
   char macro[6],
        name[36];
   int  zone,
        net,
        node,
        point;
   char SPARE[128];
};

struct _CFG {
   /* telecom config */
   int  port;
   long baud;
   int  locked;
   char init[31];
   char predial[31];
   char postdial[31];
   int  p_base,           /* used ONLY if port==5 which is a custom setup */
        p_interrupt,
        p_vector,
        call_delay;
   char SPARE_1[56];

   /* boss config */
   int  zone;
   int  net;
   int  node;
   char domain[31];
   char phone[16];
   long boss_baud;
   int  func_req:1,
        noupld:1,
        BOSS_UNUSED:14;
   char SPARE_2[64];

   /* local config */
   char name[36];
   char password[9];
   int  point;
   char origin[41];
   char archive[31];
   char unarchive[31];
   char editor[9];
   int  toss:1,
        link:1,
        logs:1,
        wrapquote:1,
        seenby:1,
        safe_unarchive:1,
        janus:1,
        LOC_UNUSED:9;
   char city[21],
        basedir[31];
   int  zapwarn;
   char c_norm_fg,
        c_norm_bg,
        c_bright_fg,
        c_bright_bg,
        c_inverse_fg,
        c_inverse_bg;
   char printer;
   char nodelist[31];
   char SPARE_3[90];

   /* AreaFix list */
   struct _AFIX afix[MAX_AFIX];

   /* Send file list */
   struct _SEND send[MAX_SEND];

   /* Request list */
   struct _FREQ freq[MAX_FREQ];

   /* Twit list */
   struct _TWIT twit[MAX_TWIT];

   /* Macros */
   struct _MACRO macro[MAX_MACRO];

   /* Hudson message base areas */
   struct _MAREA marea[MAX_AREAS];

};

