###################################
#
#  Modem and Host Scripts V2.4.1
#
#   Changes in 2.4:
#   Added script for SupraFAXModem 144LC
#
#   Changes in 2.4.1:
#   Added script for USR Courier V32.bis 
#
#   Modifications by John Mudge @ 1:352/111 (FidoNet) or 9:2500/0 (SurvNet)
#
###################################
#
#   Modem scripts
#
#  For each modem type xxx, supply script:
#
#      Modem.xxx.Dial         Dials the phone, waits for connection
#      Modem.xxx.Hangup       Gets the modem to hang up the phone
#      Modem.xxx.Status       Returns the modem's status (-1,0,1=?,no cd,cd)
#
###################################
#
#
Procedure     Modem.USR.Dial
Message   "Initializing ...."
Send   'ATM1E1&N0S0=0S7=90B0&M4<'
TimeOut   5             'Your modem is not responding, try turning it off, then on.'
Reject    "ERROR"       'Your modem said "Error" to the initialization string.'
Expect    'OK^M'        'Your modem did not say "OK".'
Wait 1
Message   'Dialing ....'
Send    'ATDT %n<'
TimeOut 60              'No connection after 1 minute.'
Reject  'NO DIALTONE'   "Your modem can't get a dial tone, check phone line to modem."
Reject  'BUSY'          'The server is fully occupied.'
Reject  'NO CARRIER'    'The server modem is not responding.  Try again.'
Expect  'CONNECT'       'Did not get the CONNECT response.'
Message        "Connected ...."
EndProcedure   Modem.USR.Dial
#
Procedure Modem.USR.HangUp
Flush
Message        "Disconnecting ...."
Wait 1
Send '+++'
Wait 2
Flush
Send 'ATH<'
DTR Off
Message        "Disconnected ...."
EndProcedure Modem.USR.HangUp
#
###############################################
#
#
##############################################
#
#
procedure     Modem.Comstation3.Dial
Message 'Initializing Comstation3 modem'
Send 'AT V1 X4 &K3 &W1<'
Reject 'ERROR'  'Modem did not like initialization string.'
Expect 'OK'     'Modem did not respond with OK.'
join Modem.Default.Dial
EndProcedure  Modem.Comstation3.Dial
##############################################
#
#
procedure     Modem.Zoom.Dial
Message 'Initializing Zoom modem'
Send 'AT V1 X4 S37=9 S38=0 N0 &D2 &W0<'
Reject 'ERROR'  'Modem did not like initialization string.'
Expect 'OK'     'Modem did not respond with OK.'
join Modem.Default.Dial
EndProcedure  Modem.Zoom.Dial
#
#
#
#
procedure     Modem.SupraFAX-144LC.Dial
Message 'Initializing SupraFAX modem'
Send 'AT V1 X4 &C1 &W \N3 &K3 &Q5 &D2<'
Reject 'ERROR'  'Modem did not like initialization string.'
Expect 'OK'     'Modem did not respond with OK.'
join Modem.Default.Dial
EndProcedure  Modem.SupraFAX-144LC.Dial
#
#
##############################################
#
#
procedure Modem.MultiModem-v32.Dial
Message   'MultiModem v.32'
Send "AT V1 X4 &C1 &E4 &E1 S13=0 $R1<"
Reject 'ERROR'    'Modem did not like initialization commands.'
Expect "OK"       'Modem did not say OK.'
join Modem.Default.Dial
EndProcedure Modem.MultiModem-v32.Dial
#
#
##############################################
#
#
procedure Modem.PowerUser-v1.5.Dial
Message   'PowerUser modem'
join Modem.Default.Dial
EndProcedure PowerUser-v1.5.Dial
#
#
procedure     Modem.Hayes.Dial
Message   'Hayes newer modem'
Send    'AT<'
Wait 2
Flush
Send     'AT V1 X4 &C1 &D2<'
TimeOut   5             'Your modem is not responding, try turning it off, then on.'
Reject    'ERROR'       'Your modem said "Error" to the initialization string.'
Expect    'OK'          'Your modem did not say "OK".'
join  Modem.Default.Dial
EndProcedure   Modem.Hayes.Dial
#
#
#
procedure     Modem.Hayes-Optima.Dial
Message   'Hayes Optima modem'
Send      'AT N1 V1 X4 &C1 &D2 &S0<'
TimeOut   5             'Your modem is not responding, try turning it off, then on.'
Reject    "ERROR"       'Your modem said "Error" to the initialization string.'
Expect    'OK'          'Your modem did not say "OK".'
join  Modem.Default.Dial
EndProcedure   Modem.Hayes.Dial
#
#
##############################################
#
procedure     Modem.Hayes-1200.Dial
Message   'Hayes 1200 baud modem'
join  Modem.Default.Dial
EndProcedure   Modem.Hayes-1200.Dial
#
#
########################################################
#
#   Below are the default procedures that are done if there is
#   no modem-specific procedure for these cases.
#

procedure     Modem.Default.Dial
Message   'Waking up your modem...'
Send      'AT E1 Q V1 %i<'
TimeOut   5             'Your modem is not responding, try turning it off, then on.'
Reject    "ERROR"       'Your modem said "Error" to the initialization string.'
Expect    'OK^M'        'Your modem did not say "OK".'
Wait 1
Message   'Dialing up the SLIP server...'
SendPT 'ATDP %n^M'  'ATDT %n^M'
TimeOut 60              'No connection after 1 minute.'
Reject  'NO DIALTONE'   "Your modem can't get a dial tone, check phone line to modem."
Reject  'BUSY'          'The server is fully occupied.'
Reject  'NO CARRIER'    'The server modem is not responding.  Try again.'
Expect  'CONNECT'       'Did not get the CONNECT response.'
Message 'SLIP server reached'
EndProcedure   Modem.Default.Dial
#
#
#
Procedure Modem.Default.HangUp
Flush
Message        "Disconnecting...."
Wait 1
Send '+++'
Wait 2
Flush
Send 'ATH<'
DTR Off
Message        'Disconnect complete.'
EndProcedure Modem.Default.HangUp
#
#
##########################################################################
#
#
#        Host Scripts
#
#
#    For each host hhh, supply two scripts:
#
#
#      Host.hhh.Login          Logs in and goes into SLIP mode
#
#      Host.hhh.LogOut         Does any logout chores (often empty)
#
#
Procedure    Host.WLN.Login
TimeOut 60      'The SLIP server is not responding.'
Message         'Waiting for SLIP server to respond.'
Quiet ON
#Expect   'Verification'
#TimeOut 5
Message         'SLIP server is responding.'
Message         'Sending your user name and password.'
Quiet OFF
Expect   'Login:'
Send '%u<'
Expect   'Password:'
Private
Send '%p<'
Reject    'Access denied'   'Your user name or password was not accepted.'
TimeOut 30    'SLIP server did not respond to your validation request.'
Expect    '==>'
TimeOut 10    'SLIP server did not respond to SLIP command.'
Send 'slip<'
Grab MYIP
Expect 'Your address is'
Message 'Login to SLIP server successful.'
EndProcedure   Host.WLN.Login
#
#
#
Procedure      Host.WLN.LogOut
EndProcedure   Host.WLN.LogOut
#
#   End of Script file
#
