/*   KEYS.H - Header file for keyboard inputs
 *   Values returned by function: NJ_GETKEY()
 *
 *   Copyright (c) Hongbo Ni 1991-1993. All Rights Reserved.
 *
 *   Last modified: HBNI 18:30:56 Thu  03-18-1993
 *   1 - 26 = CTRL A-Z
 */
#define CTRL_A           1
#define CTRL_B           2
#define CTRL_C           3
#define CTRL_D           4
#define CTRL_E           5
#define CTRL_F           6
#define CTRL_G           7
#define CTRL_H           8
#define BS               8
#define CTRL_I           9
#define TAB              9
#define CTRL_J          10
#define CTRL_ENTER      10
#define CTRL_K          11
#define CTRL_L          12
#define CTRL_M          13
#define ENTER           13
#define CTRL_N          14
#define CTRL_O          15
#define CTRL_P          16
#define CTRL_Q          17
#define CTRL_R          18
#define CTRL_S          19
#define CTRL_T          20
#define CTRL_U          21
#define CTRL_V          22
#define CTRL_W          23
#define CTRL_X          24
#define CTRL_Y          25
#define CTRL_Z          26

#define CTRL_LBRACE     27
#define ESC             27
#define SHIFT_ESC       27
#define CTRL_BACKSLASH  28
#define CTRL_RBRACE     29
#define CTRL_6          30
#define CTRL_MINUS      31

/*  32 - 127 = standard ASCII code
 * 128 - 255 = Extended ASCII code
 */
#define CTRL_BS        127
#define CTRL_BREAK     128
#define ALT_ESC        129
#define GREY_ENTER     130
#define CTRL_2         131
#define GREY_PLUS      132
#define GREY_MINUS     133
#define GREY_STAR      134
#define GREY_SLASH     135
#define BS_            136  /* BS  +128 */
#define TAB_           137  /* TAB +128 */
#define CTRL_ENTER_    138
#define SPACE_         139
#define CTRL_GREY_ENTER 140
#define ENTER_         141  /*ENTER +128 */
#define ALT_BS         142
#define SHIFT_TAB      143
#define ALT_Q          144
#define ALT_W          145
#define ALT_E          146
#define ALT_R          147
#define ALT_T          148
#define ALT_Y          149
#define ALT_U          150
#define ALT_I          151
#define ALT_O          152
#define ALT_P          153
#define ALT_LBRACE     154
#define ALT_RBRACE     155
#define ALT_ENTER      156
#define NULL157        157
#define ALT_A          158
#define ALT_S          159
#define ALT_D          160
#define ALT_F          161
#define ALT_G          162
#define ALT_H          163
#define ALT_J          164
#define ALT_K          165
#define ALT_L          166
#define ALT_SEMICOLON  167
#define ALT_RQUOTE     168
#define ALT_LQUOTE     169
#define NULL170        170
#define ALT_BACKSLASH  171
#define ALT_Z          172
#define ALT_X          173
#define ALT_C          174
#define ALT_V          175
#define ALT_B          176
#define ALT_N          177
#define ALT_M          178
#define ALT_COMMA      179
#define ALT_DOT        180
#define ALT_SLASH      181
#define NULL182        182
#define ALT_GREY_STAR  183
#define NULL184        184
#define NULL185        185
#define NULL186        186
#define F1             187
#define F2             188
#define F3             189
#define F4             190
#define F5             191
#define F6             192
#define F7             193
#define F8             194
#define F9             195
#define F10            196
#define NULL197        197
#define NULL198        198
#define HOME           199
#define UP             200
#define PGUP           201
#define ALT_GREY_MINUS 202
#define LEFT           203
#define KEYPAD_5       204
#define RIGHT          205
#define ALT_GREY_PLUS  206
#define END            207
#define DOWN           208
#define PGDN           209
#define INS            210
#define INSERT         210
#define DEL            211
#define SHIFT_F1       212
#define SHIFT_F2       213
#define SHIFT_F3       214
#define SHIFT_F4       215
#define SHIFT_F5       216
#define SHIFT_F6       217
#define SHIFT_F7       218
#define SHIFT_F8       219
#define SHIFT_F9       220
#define SHIFT_F10      221
#define CTRL_F1        222
#define CTRL_F2        223
#define CTRL_F3        224
#define CTRL_F4        225
#define CTRL_F5        226
#define CTRL_F6        227
#define CTRL_F7        228
#define CTRL_F8        229
#define CTRL_F9        230
#define CTRL_F10       231
#define ALT_F1         232
#define ALT_F2         233
#define ALT_F3         234
#define ALT_F4         235
#define ALT_F5         236
#define ALT_F6         237
#define ALT_F7         238
#define ALT_F8         239
#define ALT_F9         240
#define ALT_F10        241
#define NULL242        242
#define CTRL_LEFT      243
#define CTRL_RIGHT     244
#define CTRL_END       245
#define CTRL_PGDN      246
#define CTRL_HOME      247
#define ALT_1          248
#define ALT_2          249
#define ALT_3          250
#define ALT_4          251
#define ALT_5          252
#define ALT_6          253
#define ALT_7          254
#define ALT_8          255
/*
 * 256 - 299 = Enhanced keyboard
 */
#define ALT_9          256
#define ALT_0          257
#define ALT_MINUS      258
#define ALT_PLUS       259
#define CTRL_PGUP      260
#define F11            261
#define F12            262
#define SHIFT_F11      263
#define SHIFT_F12      264
#define CTRL_F11       265
#define CTRL_F12       266
#define ALT_F11        267
#define ALT_F12        268
#define CTRL_UP        269
#define CTRL_GREY_MINUS 270
#define CTRL_KEYPAD_5  271
#define CTRL_GREY_PLUS 272
#define CTRL_DOWN      273
#define CTRL_INS       274
#define CTRL_DEL       275
#define CTRL_TAB       276
#define CTRL_GREY_SLASH 277
#define CTRL_GREY_STAR 278
#define ALT_HOME       279
#define ALT_UP         280
#define ALT_PGUP       281
#define NULL282        282
#define ALT_LEFT       283
#define NULL284        284
#define ALT_RIGHT      285
#define NULL286        286
#define ALT_END        287
#define ALT_DOWN       288
#define ALT_PGDN       289
#define ALT_INS        290
#define ALT_DEL        291
#define ALT_GREY_SLASH 292
#define ALT_TAB        293
#define ALT_GREY_ENTER 294
#define KEY__MAX       295
/*
 * DEFINE MOUSE KEYS 296-305
 */
#define M_LR           296     /* Both button released */
#define M_LEFT         297     /* left button released */
#define M_RIGHT        298     /* right button released */
#define M_LL           299     /* double left button released */
#define M_RR           300     /* double right button released */
#define M_MID          301     /* middle button released */
#define M_MM           302     /* double middle button released */

/*
 * SHIFT+GREYKEYS
*/
#define SHIFT_GREY_ENTER  320
#define SHIFT_GREY_PLUS   321
#define SHIFT_GREY_MINUS  322
#define SHIFT_GREY_STAR   323
#define SHIFT_GREY_SLASH  324
#define SHIFT_BS          325
#define SHIFT_ENTER       326
#define SHIFT_HOME        327
#define SHIFT_UP          328
#define SHIFT_PGUP        329
#define SHIFT_LEFT        330
#define SHIFT_KEYPAD_5    331
#define SHIFT_RIGHT       332
#define SHIFT_END         333
#define SHIFT_DOWN        334
#define SHIFT_PGDN        335
#define SHIFT_INS         336
#define SHIFT_DEL         337
/* End of file   KEY.H     */
