REM $INCLUDE: 'qbx.bi'
DIM inregs AS regtypex, outregs AS regtypex
DIM asciz AS STRING * 128
IF COMMAND$ = "" THEN
   PRINT "Usage:"
   PRINT "Touch <filename>"
   END
END IF
Debug = 0
' open existing file
asciz = UCASE$(COMMAND$)
asciz = LEFT$(asciz, 127) + CHR$(0)
inregs.ax = &H3D00
inregs.ds = VARSEG(asciz)
inregs.dx = VARPTR(asciz)
CALL interruptx(&H21, inregs, outregs)
IF (outregs.flags AND 1) = 1 THEN
    PRINT "Error opening "; COMMAND$
    END
END IF
' get file's date and time
handle = outregs.ax
inregs.ax = &H5700
inregs.bx = handle
CALL interruptx(&H21, inregs, outregs)
IF (outregs.flags AND 1) = 1 THEN
    PRINT "Error reading "; COMMAND$
    END
END IF
' dislay file's time and date
IF Debug THEN
   GOSUB DisplayFile
END IF
' rem touch file
d$ = DATE$
year = VAL(RIGHT$(d$, 4)) - 1980
month = VAL(LEFT$(d$, 2))
day = VAL(MID$(d$, 4, 2))
t$ = TIME$
hours = VAL(LEFT$(t$, 2))
IF hours = 24 THEN hours = 0
minutes = VAL(MID$(t$, 4, 2))
seconds = INT(VAL(RIGHT$(t$, 2)) / 2)
inregs.ax = &H5701
inregs.bx = handle
newtime! = hours * 2 ^ 11 + minutes * 2 ^ 5 + seconds
c$ = "&h" + HEX$(newtime!)
inregs.cx = VAL(c$)
newdate! = year * 2 ^ 9 + month * 2 ^ 5 + day
c$ = "&h" + HEX$(newdate!)
inregs.dx = VAL(c$)
CALL interruptx(&H21, inregs, outregs)
IF (outregs.flags AND 1) = 1 THEN
    PRINT "Error resetting "; COMMAND$
    END
END IF
' close file
inregs.ax = &H3E00
inregs.bx = handle
CALL interruptx(&H21, inregs, outregs)
IF (outregs.flags AND 1) = 1 THEN
    PRINT "Error closing "; COMMAND$
    END
END IF
PRINT "File "; COMMAND$; " touched."
END

DisplayFile:
' parse time
PRINT "Current file date and time:"
filedate = outregs.dx
IF filedate < 0 THEN
   filedate = filedate + 65536
END IF
REM day:
REM 1111 1198 7654 3210
REM 5432 10
REM 0000 0000 000x xxxx
day = filedate AND &H1F
REM month:
REM 1111 1198 7654 3210
REM 5432 10
REM 0000 000x xxx0 0000
month = filedate AND &H1E0
month = month / 2 ^ 5
REM year - 1980
REM 1111 1198 7654 3210
REM 5432 10
REM xxxx xxx0 0000 0000
year = filedate AND &HFE00
year = year / 2 ^ 9
year = year + 1980
filetime = outregs.cx
IF filetime < 0 THEN
   filetime = filetime + 65536
END IF
REM seconds/2:
REM 1111 1198 7654 3210
REM 5432 10
REM 0000 0000 000x xxxx
seconds = filetime AND &H1F
seconds = seconds * 2
REM minutes:
REM 1111 1198 7654 3210
REM 5432 10
REM 0000 0xxx xxx0 0000
minutes = filetime AND &H7E0
minutes = minutes / 2 ^ 5
REM hours:
REM 1111 1198 7654 3210
REM 5432 10
REM xxxx x000 0000 0000
hours = filetime AND &HF800
hours = hours / 2 ^ 11
PRINT "Year"; year; " Month"; month; " Day"; day
PRINT "Hours"; hours; " Minutes"; minutes; " Seconds"; seconds
RETURN

